<?php
require_once( 'utility.php' ) ;
function setup_nat_network( $argv ) {
	global $DTASCFG_XML_FILE ;

	/* check number of arguments */
	if( count( $argv ) < 1 ) {
		echo "Usage: setup_nat_network DHCP IP MASK GATEWAY DNS\n";
		exit( 1 ) ;
	}

	$dhcp_enabled = $argv[ 0 ] ;
	if( ! $dhcp_enabled ) {
		if( count( $argv ) != 5 ) {
			echo "Usage: setup_nat_network DHCP IP MASK GATEWAY DNS\n" ;
			exit( 1 ) ;
		}
	}

	$ip      = $dhcp_enabled ? "" : $argv[ 1 ] ;
	$mask    = $dhcp_enabled ? "" : $argv[ 2 ] ;
	$gateway = $dhcp_enabled ? "" : $argv[ 3 ] ;
	$dns     = $dhcp_enabled ? "" : $argv[ 4 ] ;

	$xml     = simplexml_load_file( $DTASCFG_XML_FILE ) ;
    $usbxcli = chop( $xml -> u_sandbox -> cli_path ) ;
    
    try {
        debug_print( "[Usbx] SetupNatNetworkSuccess" ) ;
        $ret_array = array() ;
        if( $dhcp_enabled == 1 ) {
            $ret_array = run_program_at_sc_by_ssh( array(
                'program'   => "/usr/bin/python", 
                'arguments' => array(
                    $usbxcli,   "set-gateway",
                    "--type",   "dhcp",
                    "--bindif", "eth2" ) ) ) ;
        }
        
        else {
            $ret_array = run_program_at_sc_by_ssh( array(
                'program'   => "/usr/bin/python", 
                'arguments' => array(
                    $usbxcli,    "set-gateway",
                    "--type",    "static",
                    "--bindif",  "eth2",
                    "--ip",      $ip,
                    "--netmask", $mask,
                    "--gateway", $gateway,
                    "--dns",     $dns ) ) ) ;

        }
        
        $retCode      = $ret_array[ 0 ] ;
        $stdoutMsgAry = $ret_array[ 1 ] ;
        $stdoutMsg    = join( "\n", $stdoutMsgAry ) ;
        if( $retCode != 0 ) {
            $stderrMsgAry = $ret_array[ 2 ] ;
            $stderrMsg    = join( "\n", $stderrMsgAry ) ;
            throw new Exception( "FailToSetupNatNetwork: ret=$retCode, stdoutMsg='$stdoutMsg', stderrMsg='$stderrMsg'" ) ;
        }
        debug_print( "SetupNatNetworkSuccess: $stdoutMsg" ) ;

        $retryCount    = 0 ;
        $retryCountMax = 3 ;
        while( 1 ) {
            $ret_array = run_program_at_sc_by_ssh( array(
                'program'   => "/usr/bin/python", 
                'arguments' => array( $usbxcli, "set-gateway" ) ) ) ;
            $retCode      = $ret_array[ 0 ] ;
            $stdoutMsgAry = $ret_array[ 1 ] ;
            $stdoutMsg    = join( ", ", $stdoutMsgAry ) ;
            if( $retCode != 0 ) {
                $stderrMsgAry = $ret_array[ 2 ] ;
                $stderrMsg    = join( "\n", $stderrMsgAry ) ;
                throw new Exception( "GetGatewayInfoFromUsbxFail: ret=$retCode, stdoutMsg='$stdoutMsg', stderrMsg='$stderrMsg'" ) ;
            }
            debug_print( "GetGatewayInfoFromUsbxSuccess: $stdoutMsg" ) ;
            
            if( preg_match( "/IP: N\/A/i", $stdoutMsg, $matches ) === 0 ) {
                debug_print( "SetupNatNetworkSuccess: msg='$stdoutMsg'" ) ;
                break ;
            }
            
            # IP is still 'N/A'
            debug_print( "SetupNatNetworkInProgress: IP=N/A, retry($retryCount/$retryCountMax)..." ) ;
            sleep( 10 ) ;
            
            $retryCount++ ;
            if( $retryCount > $retryCountMax ) {
                $stderrMsgAry = $ret_array[ 2 ] ;
                $stderrMsg    = join( "\n", $stderrMsgAry ) ;
                throw new Exception( "SetupNatNetworkFail: ret=$retCode, stdoutMsg='$stdoutMsg', stderrMsg='$stderrMsg'" ) ;
            }
        }
    
        preg_match( "/IP: ([^,]*)/i", $stdoutMsg, $matches ) ;
        $result_ip = $matches[ 1 ] ;
        
        preg_match( "/Netmask: ([^,]*)/i", $stdoutMsg, $matches ) ;
        $result_mask = $matches[ 1 ] ;
        
        preg_match( "/DNS: ([^,]*)/i", $stdoutMsg, $matches ) ;
        $result_dns = $matches[ 1 ] ;

        preg_match( "/Gateway: ([^,]*)/i", $stdoutMsg, $matches ) ;
        $result_gateway = $matches[ 1 ] ;

        echo "$result_ip $result_mask $result_gateway $result_dns" ;
        exit( 0 ) ;
    }
    
    catch( Exception $e ) {
        $msg = "[" . $e -> getFile() . "(" . $e -> getLine() . ")]: " . $e -> getMessage() ;
        shm_print_error( $msg ) ;
        debug_print( "Exception caught: $msg" ) ;
        echo $msg;
        exit( 1 ) ;
    }
    
    return ;
}

